﻿using SnapsLibrary;
using System.Collections.Generic;

using Newtonsoft.Json;

public class Ch10_06_TimeTrackerJson
{
    class Contact
    {
        public string ContactName;
        public string ContactAddress;
        public string ContactPhone;

        public int MinutesSpent;

        public Contact(string name, string address, string phone)
        {
            this.ContactName = name;
            this.ContactAddress = address;
            this.ContactPhone = phone;
            this.MinutesSpent = 0;
        }
    }

    void makeTestData()
    {
        string[] testNames = {
            "Rob", "Marysia", "Dawid", "Joanna",
            "Szymon", "Konrad", "Helena", "Krzystof",
            "Amanda", "Sandra" };

        // the number of minutes for contacts
        int minutes = 0;

        foreach (string name in testNames)
        {
            Contact newContact = new Contact(name: name,
                address: name + " dom",
                phone: name + " dom");
            newContact.MinutesSpent = minutes;
            minutes = minutes + 30;
            storeContact(newContact);
        }
    }

    string SAVE_NAME = "TimeTracker.json";

    List<Contact> contacts = new List<Contact>();

    void storeContact(Contact contact)
    {
        contacts.Add(contact);
        storeAllContacts();
    }

    void storeAllContacts()
    {
        string json = JsonConvert.SerializeObject(contacts);

        SnapsEngine.SaveStringToLocalStorage(itemName: SAVE_NAME, itemValue: json);
    }

    void loadAllContacts()
    {
        string json = SnapsEngine.FetchStringFromLocalStorage(SAVE_NAME);

        if (json == null)
        {
            // Jeśli dotarliśmy tutaj, w lokalnej pamięci nie ma żadnego łańcucha znaków
            SnapsEngine.WaitForButton("Utworzono pustą pamięć dla Rejestru czasu pracy");
            contacts = new List<Contact>();
        }
        else
        {
            contacts = JsonConvert.DeserializeObject<List<Contact>>(json);
        }
    }

    void newContact()
    {
        SnapsEngine.SetTitleString("Nowy kontakt");
        string name = SnapsEngine.ReadString("Wpisz nazwę nowego kontaktu");
        string address = SnapsEngine.ReadMultiLineString("Wspisz adres kontaktu");
        string phone = SnapsEngine.ReadString("Wpisz telefon kontaktu");

        Contact newContact = new Contact(name: name, address: address, phone: phone);

        storeContact(newContact);

        storeAllContacts();

        SnapsEngine.DisplayString("Kontakt został zapisany");

    }

    void findContact()
    {
        SnapsEngine.SetTitleString("Znajdź kontakt");

        string name = SnapsEngine.ReadString("Wpisz nazwę kontaktu");

        string resultString = "Nie znaleziono kontaktu";

        foreach (Contact contact in contacts)
        {
            if (contact.ContactName == name)
            {
                resultString =
                    "Nazwa: " + contact.ContactName + "\n" +
                    "Adres: " + contact.ContactAddress + "\n" +
                    "Telefon: " + contact.ContactPhone + "\n" +
                    "Minuty: " + contact.MinutesSpent.ToString();
                break;
            }
        }
        SnapsEngine.DisplayString(resultString);
        SnapsEngine.WaitForButton("Dalej");
        SnapsEngine.DisplayString("");
    }

    void addMinutes()
    {
        SnapsEngine.SetTitleString("Dodaj minuty");

        string name = SnapsEngine.ReadString("Wpisz nazwę kontaktu");
        int minutes = SnapsEngine.ReadInteger("Wpisz minuty dla kontaktu");

        string resultString = "Nie znaleziono kontaktu";

        for (int position = 0; position < contacts.Count; position = position + 1)
        {
            if (contacts[position].ContactName == name)
            {
                resultString = "Liczba dodanych minut: " + minutes + "\n" +
                    "do " + name;
                contacts[position].MinutesSpent = contacts[position].MinutesSpent + minutes;
                break;
            }
        }

        storeAllContacts();

        SnapsEngine.DisplayString(resultString);
        SnapsEngine.WaitForButton("Dalej");
        SnapsEngine.DisplayString("");
    }

    void displaySummary()
    {
        SnapsEngine.SetTitleString("Wyświetl podsumowanie");

        for (int pass = 0; pass < contacts.Count - 1; pass = pass + 1)
        {
            for (int i = 0; i < contacts.Count - 1; i = i + 1)
            {
                if (contacts[i].MinutesSpent < contacts[i + 1].MinutesSpent)
                {
                    // elementy są w złej kolejności, trzeba je pozamieniać
                    Contact temp = contacts[i];
                    contacts[i] = contacts[i + 1];
                    contacts[i + 1] = temp;
                }
            }
        }

        string result = "";
        int listLimit;

        if (contacts.Count < 5)
            listLimit = contacts.Count;
        else
            listLimit = 5;

        for (int position = 0; position < listLimit; position = position + 1)
        {
            if (contacts[position].ContactName == null)
                continue;
            result = result + contacts[position].ContactName +
                ":" + contacts[position].MinutesSpent + "\n";
        }

        SnapsEngine.SetTitleString("Czasy kontaktów");

        SnapsEngine.DisplayString(result);

        SnapsEngine.WaitForButton("Dalej");

        SnapsEngine.DisplayString("");
    }

    public void StartProgram()
    {
        // Usuń tę instrukcję, zanim sprzedaż program
        // makeTestData();

        storeAllContacts();

        loadAllContacts();

        while (true)
        {
            SnapsEngine.SetTitleString("Rejestr czasu pracy");

            string command = SnapsEngine.SelectFrom4Buttons("Nowy kontakt", "Znajdź kontakt",
                "Dodaj minuty", "Wyświetl podsumowanie");

            switch (command)
            {
                case "Nowy kontakt":
                    newContact();
                    break;

                case "Znajdź kontakt":
                    findContact();
                    break;

                case "Dodaj minuty":
                    addMinutes();
                    break;

                case "Wyświetl podsumowanie":
                    displaySummary();
                    break;
            }
        }
    }
}
